<?php

namespace Mtc\Members\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;
use Mtc\Foundation\Rules\ValidPostcode;
use Mtc\Members\Contracts\MemberModel;
use Mtc\Members\MemberAddress;

/**
 * Class SaveAdminMemberAddressRequest
 *
 * @package Mtc\Members\Http\Requests
 */
class SaveAdminMemberAddressRequest extends AdminMemberAddressRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'first_name' => 'required',
            'last_name' => 'required',
            'address1' => 'required|max:200',
            'address2' => 'max:200',
            'city' => 'required',
            'country_code' => 'required|exists:countries,code',
            'postcode' => new ValidPostcode($this->request->get('country_code')),
        ];
    }
}
