<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('invoices')) {
            Schema::create('invoices', function (Blueprint $table) {
                $table->increments('id');
                $table->morphs('payable');
                $table->string('reference', 100)->index();
                $table->unsignedInteger('customer_id')->nullable()->index();
                $table->string('name', 100)->nullable()->index();
                $table->string('email', 100)->nullable()->index();
                $table->string('contact_number', 20)->nullable();
                $table->tinyInteger('status')->default(0)->index();
                $table->decimal('amount', 10)->nullable();
                $table->decimal('amount_ex_vat', 10)->nullable();
                $table->decimal('amount_in_currency', 10)->nullable();
                $table->string('currency', 5)->index();
                $table->decimal('outstanding_amount', 10)->nullable()->index();
                $table->decimal('outstanding_amount_ex_vat', 10)->nullable();
                $table->decimal('vat_value', 10)->nullable();
                $table->boolean('use_ex_vat')->default(0);
                $table->text('details')->nullable();
                $table->date('due_at')->nullable();
                $table->string('template')->nullable();
                $table->smallInteger('invite_emails_sent')->default(0);
                $table->dateTime('last_payment_invite_email')->nullable();
                $table->timestamps();
            });

            Schema::create('invoice_items', function (Blueprint $table) {
                $table->increments('id');
                $table->unsignedInteger('invoice_id')->nullable()->index();
                $table->unsignedInteger('purchasable_id')->nullable();
                $table->nullableMorphs('parent');
                $table->string('purchasable_type')->nullable();
                $table->string('name')->nullable();
                $table->decimal('value', 10)->nullable();
                $table->decimal('value_ex_vat', 10)->nullable();
                $table->decimal('original_value', 10)->nullable();
                $table->decimal('original_value_ex_vat', 10)->nullable();
                $table->integer('quantity');
                $table->decimal('line_total', 10)->nullable();
                $table->decimal('line_total_ex_vat', 10)->nullable();
                $table->string('vat_rate')->nullable();
                $table->text('details')->nullable();
                $table->timestamps();
                $table->softDeletes();
                $table->index([
                    'purchasable_id',
                    'purchasable_type',
                ]);
            });

            Schema::create('invoice_lines', function (Blueprint $table) {
                $table->increments('id');
                $table->unsignedInteger('invoice_id')->nullable()->index();
                $table->nullableMorphs('parent');
                $table->string('type', 50)->index();
                $table->string('name');
                $table->boolean('is_negative')->nullable()->index();
                $table->decimal('value', 10)->nullable();
                $table->decimal('value_ex_vat', 10)->nullable();
                $table->timestamps();
            });

            Schema::create('invoice_payments', function (Blueprint $table) {
                $table->increments('id');
                $table->unsignedInteger('invoice_id')->nullable()->index();
                $table->string('provider', 100)->index();
                $table->decimal('amount', 10);
                $table->string('currency_code', 5)->index()->nullable();
                $table->decimal('amount_in_currency', 10)->nullable();
                $table->dateTime('failed_at')->nullable()->index();
                $table->text('failure_details')->nullable();
                $table->string('reference', 100)->index();
                $table->dateTime('confirmed_at')->nullable()->index();
                $table->text('details')->nullable();
                $table->timestamps();
            });

            Schema::create('invoice_addresses', function (Blueprint $table) {
                $table->increments('id');
                $table->unsignedInteger('invoice_id')->nullable()->index();
                $table->string('type', 20)->index();
                $table->string('title')->nullable();
                $table->string('first_name')->nullable();
                $table->string('last_name')->nullable();
                $table->string('address1')->nullable();
                $table->string('address2')->nullable();
                $table->string('city')->nullable();
                $table->string('county')->nullable();
                $table->string('postcode')->nullable();
                $table->string('country')->nullable();
                $table->string('state')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoices');
        Schema::dropIfExists('invoice_items');
        Schema::dropIfExists('invoice_lines');
        Schema::dropIfExists('invoice_payments');
        Schema::dropIfExists('invoice_addresses');
    }
};
