<?php

namespace Mtc\MercuryDataModels\Casts;

use Carbon\Carbon;
use Illuminate\Contracts\Database\Eloquent\CastsAttributes;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Storage;

class SpecifiedTypeCast implements CastsAttributes
{
    /**
     * Cast the given value.
     *
     * @param  Model  $model
     * @param  string  $key
     * @param  mixed  $value
     * @param  array  $attributes
     * @return mixed
     */
    public function get($model, string $key, $value, array $attributes)
    {
        $disk = Config::get('filesystems.default_media');
        return match ($model->getAttribute('type')) {
            'date', 'datetime' => Carbon::parse($value),
            'int' => (int)$value,
            'bool', 'boolean', 'verify' => (bool)$value,
            'float', 'double' => (double)$value,
            'secret' => decrypt($value),
            'text' => $model->getAttribute('value_text'),
            'image' => [
                'path' => $value,
                'url' => !empty($value) ? Storage::disk($disk)->url($value ?? '') : '',
            ],
            default => $value,
        };
    }

    /**
     * Prepare the given value for storage.
     *
     * @param  Model  $model
     * @param  string  $key
     * @param  mixed  $value
     * @param  array  $attributes
     * @return mixed
     */
    public function set($model, string $key, $value, array $attributes)
    {
        if ($attributes['type'] === 'text') {
            return [
                'value' => null,
                'value_text' => $value
            ];
        }

        if ($attributes['type'] === 'secret') {
            return encrypt($value);
        }

        if ($attributes['type'] === 'image') {
            return is_array($value) ? $value['path'] : $value;
        }

        return $value;
    }
}
