<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Support\Facades\Config;
use Mtc\ContentManager\Traits\HasMedia;
use Mtc\MercuryDataModels\Factories\CatalogOfferFactory;

class CatalogOffer extends Model
{
    use HasFactory;
    use HasMedia;

    protected $fillable = [
        'name',
        'subtitle',
        'link',
        'button_text',
        'active',
    ];

    protected static function newFactory()
    {
        return CatalogOfferFactory::new();
    }

    public function vehicles(): BelongsToMany
    {
        return $this->belongsToMany(Vehicle::class);
    }

    /**
     * Define thumbnail sizes to auto-generate for this model
     *
     * @return mixed
     */
    public function getDefaultAllowedMediaSizesAttribute()
    {
        return Config::get('automotive.catalog_offers_sizes', []);
    }

    public function scopeActive(Builder $query): void
    {
        $query->where('active', 1);
    }

    public function getPreviewImage(string $dimensions): ?string
    {
        $non_resizeable_url = $this->tryGetNonResizeableMedia();

        if (!empty($non_resizeable_url)) {
            return $non_resizeable_url;
        }

        if ($this->relationLoaded('primaryMediaUse')) {
            $image = $this->primaryMediaUse;
        } elseif ($this->relationLoaded('mediaUses')) {
            $image = $this->mediaUses
                ->sortBy('primary')
                ->first();
        } else {
            $image = $this->mediaUses()
                ->orderByDesc('primary')
                ->first();
        }

        return $image?->getUrl($dimensions);
    }

    private function tryGetNonResizeableMedia(): string
    {
        $media_use = $this->mediaUses()->first();

        if (empty($media_use)) {
            return '';
        }

        $media = $media_use->media;

        if (empty($media)) {
            return '';
        }

        if (!$media->resizableMime()) {
            return $media->getOriginalUrlAttribute();
        }

        return '';
    }
}
