<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\ServiceProvider;
use Mtc\MercuryDataModels\Contracts\LocatingServiceEngine;
use Mtc\MercuryDataModels\Services\Location\PafLocationService;

class DataProvider extends ServiceProvider
{
    public function register()
    {
        $this->mergeConfigFrom(dirname(__DIR__) . '/config/automotive.php', 'automotive');
        $this->mergeConfigFrom(dirname(__DIR__) . '/config/features.php', 'features');
    }

    public function boot()
    {
        $this->app->bind(LocatingServiceEngine::class, PafLocationService::class);

        Relation::morphMap([
            'user' => \config('auth.providers.users.model'),
            'dealership' => Dealership::class,
            'franchise' => Franchise::class,
            'vehicle' => Vehicle::class,
            'offer' => VehicleOffer::class,
            'offer-content' => VehicleOfferContent::class,
            'offer-version' => VehicleOfferContentHistory::class,
            'new-car' => NewCar::class,
            'new-car-content' => NewCarContent::class,
            'new-car-version' => NewCarContentHistory::class,
            'make' => VehicleMake::class,
            'model' => VehicleModel::class,
            'fuel_type' => FuelType::class,
            'transmission' => TransmissionType::class,
            'body_type' => BodyStyleType::class,
            'drivetrain' => DrivetrainType::class,
            'seo-default' => SeoDefault::class,
            'seo-data' => SeoData::class,
            'setting' => Setting::class,
            'property-attribute' => PropertyAttributeValue::class,
            'catalog-offer' => CatalogOffer::class,
        ]);
    }
}
