<?php

namespace Mtc\MercuryDataModels\Factories;

use App\BillableType;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use Mtc\MercuryDataModels\Billable;
use Mtc\MercuryDataModels\Booking;
use Mtc\MercuryDataModels\BookingStatus;

class BookingFactory extends Factory
{
    protected $model = Booking::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $time = match(random_int(0, 3)) {
            0 => 9,
            1 => 11,
            2 => 13,
            3 => 15,
        };
        return [
            'customer_id' => random_int(1, 1000),
            'registration_number' => strtoupper(Str::random(8)),
            'mileage' => random_int(1, 100) * 1000,
            'vehicle_data' => [],
            'email' => $this->faker->email(),
            'location_id' => random_int(1, 10),
            'phone_number' => $this->faker->phoneNumber(),
            'first_name' => $this->faker->firstName(),
            'last_name' => $this->faker->lastName(),
            'booking_time' => Carbon::now()->subDays(random_int(-30, 30))->setTime($time, 0),
            'data' => [],
            'delivery_option_id' => random_int(1, 3),
            'status' => collect(BookingStatus::cases())->pluck('value')->random(1)->first(),
        ];
    }
}
