<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddInvoiceDataToTenants extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('tenants', function (Blueprint $table) {
            $table->dateTime('last_invoice_created_at')->nullable()->index();
            $table->date('next_invoice_due_at')->nullable()->index();
            $table->string('tier', 20)->nullable()->index();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('tenants', function (Blueprint $table) {
            $table->dropColumn([
                'last_invoice_created_at',
                'next_invoice_due_at',
                'tier',
            ]);
        });
    }
}
