<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // rename commands are split out because multiple actions at once are not supported by sqlite
        Schema::table('vehicle_offer_finance', function (Blueprint $table) {
            $table->renameColumn('type', 'finance_type');
        });
        Schema::table('vehicle_offer_finance', function (Blueprint $table) {
            $table->renameColumn('number_of_months', 'number_of_payments');
        });
        Schema::table('vehicle_offer_finance', function (Blueprint $table) {
            $table->renameColumn('monthly_payment', 'monthly_price');
        });
        Schema::table('vehicle_offer_finance', function (Blueprint $table) {
            $table->renameColumn('first_monthly', 'first_payment');
            $table->smallInteger('term')->nullable();
        });
        Schema::table('vehicle_finance', function (Blueprint $table) {
            $table->decimal('total_credit_amount')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicle_offer_finance', function (Blueprint $table) {
            $table->renameColumn('finance_type', 'type');
            $table->renameColumn('number_of_payments', 'number_of_months');
            $table->renameColumn('monthly_price', 'monthly_payment');
            $table->renameColumn('first_payment', 'first_monthly');
            $table->dropColumn('term');
        });
        Schema::table('vehicle_finance', function (Blueprint $table) {
            $table->dropColumn('total_credit_amount');
        });
    }
};
