<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('scheduled_tasks', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->boolean('is_active')->default(0)->index();
            $table->foreignId('parent_id')->index()->nullable();
            $table->boolean('is_ready')->index()->nullable();
            $table->boolean('is_running')->default(0)->index()->nullable();
            $table->dateTime('last_processed_at')->nullable();
            $table->dateTime('last_failed_at')->nullable();
            $table->dateTime('next_due_at')->nullable();
            $table->string('schedule')->nullable();
            $table->string('schedule_hours')->nullable();
            $table->string('provider')->nullable();
            $table->string('type')->nullable();
            $table->text('data')->nullable();
            $table->timestamps();
        });
        Schema::create('scheduled_task_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('task_id');
            $table->boolean('was_successful')->index()->nullable();
            $table->dateTime('finished_at')->nullable();
            $table->unsignedInteger('jobs_started')->nullable();
            $table->unsignedInteger('jobs_finished')->nullable();
            $table->text('data')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('scheduled_tasks');
        Schema::dropIfExists('scheduled_task_logs');
    }
};
