<?php

namespace Mtc\MercuryDataModels\Factories;

use Exception;
use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\SeoRedirect;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\Mtc\MercuryDataModels\SeoDefault>
 */
class SeoRedirectFactory extends Factory
{
    protected $model = SeoRedirect::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     * @throws Exception
     */
    public function definition(): array
    {
        return [
            'from' => strtolower(implode('-', $this->faker->words(3))),
            'to' => strtolower(implode('-', $this->faker->words(3))),
            'code' => $this->faker->randomElement([301, 306, 307, 308]),
            'from_domain' => 'https://' . $this->faker->domainName() . '/',
            'to_domain' => 'https://' . $this->faker->domainName() . '/',
        ];
    }
}
