<?php

namespace Mtc\MercuryDataModels;

use Mtc\ContentManager\Contracts\VersionModel;
use Ramsey\Uuid\Uuid;

class PageVersion extends VersionModel
{
    public function url(): string
    {
        $prefix = app()->environment('local') ? 'http://' : 'https://';
        return tenant()->primaryDomain
            ? $prefix . tenant()->primaryDomain->domain . $this->page->urlPath() . '?v=' . $this->uuid
            : $prefix . tenant()->domains()->first()->domain . $this->page->urlPath() . '?v=' . $this->uuid;
    }

    public function getStatusAttribute(): string
    {
        if ($this->attributes['request_changes']) {
            return __('pages.changes_requested');
        }

        if ($this->attributes['pending_review']) {
            return __('pages.pending_review');
        }

        return $this->attributes['is_active']
            ? __('pages.is_active')
            : __('pages.draft');
    }
}
