<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * @property ?ScheduledTask $task
 */
class ScheduledTaskLog extends Model
{
    protected $fillable = [
        'task_id',
        'was_successful',
        'finished_at',
        'jobs_started',
        'jobs_finished',
        'data',
    ];

    protected $casts = [
        'data' => 'array',
        'was_successful' => 'boolean',
        'finished_at' => 'datetime',
    ];

    public function task(): BelongsTo
    {
        return $this->belongsTo(ScheduledTask::class, 'task_id');
    }

    public function addNote(string $text, bool $trigger_update = true): void
    {
        $notes = $this->data ?? [];
        $notes[] = $text;
        $this->data = $notes;

        // May not want to update immediately
        if ($trigger_update) {
            $this->update([
                'data' => $notes,
            ]);
        }
    }
}
