<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Relations\MorphOne;
use Mtc\Crm\Traits\ModelSortAndFilter;
use Mtc\MercuryDataModels\Factories\BodyStyleTypeFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Mtc\MercuryDataModels\Traits\EnsuresSlug;
use Mtc\MercuryDataModels\Traits\OrderByName;

class BodyStyleType extends Model
{
    use HasFactory;
    use OrderByName;
    use ModelSortAndFilter;
    use EnsuresSlug;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'body_styles';

    /**
     * Mass assign columns
     *
     * @var string[]
     */
    protected $fillable = [
        'id',
        'name',
        'slug',
        'autotrader_id',
        'has_subcategories',
        'small_if_under',
        'large_if_above',
    ];

    /**
     * Columns shown in JSON response by default
     *
     * @var string[]
     */
    protected $visible = [
        'id',
        'name',
        'slug',
    ];

    protected static function boot()
    {
        parent::boot();

        self::saving(function (self $bodyStyleType) {
            $bodyStyleType->ensureSlug();
        });
    }

    /**
     * Model factory
     *
     * @return BodyStyleTypeFactory
     */
    protected static function newFactory()
    {
        return BodyStyleTypeFactory::new();
    }

    protected function getSlugAttribute(): string
    {
        return $this->attributes['slug'];
    }
}
