<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Support\Facades\Config;
use Mtc\ContentManager\Traits\HasMedia;
use Mtc\MercuryDataModels\Factories\CatalogOfferFactory;

class CatalogOffer extends Model
{
    use HasFactory;
    use HasMedia;

    protected $fillable = [
        'name',
        'subtitle',
        'link',
        'button_text',
        'active',
    ];

    protected static function newFactory()
    {
        return CatalogOfferFactory::new();
    }

    public function vehicles(): BelongsToMany
    {
        return $this->belongsToMany(Vehicle::class);
    }

    /**
     * Define thumbnail sizes to auto-generate for this model
     *
     * @return mixed
     */
    public function getDefaultAllowedMediaSizesAttribute()
    {
        return Config::get('automotive.catalog_offers_sizes', []);
    }

    public function scopeActive(Builder $query): void
    {
        $query->where('active', 1);
    }
}
