<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Relations\MorphOne;
use Mtc\Crm\Traits\ModelSortAndFilter;
use Mtc\MercuryDataModels\Factories\FuelTypeFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Mtc\MercuryDataModels\Traits\EnsuresSlug;
use Mtc\MercuryDataModels\Traits\OrderByName;

class FuelType extends Model
{
    use HasFactory;
    use OrderByName;
    use ModelSortAndFilter;
    use EnsuresSlug;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'fuel_types';

    /**
     * Mass assign columns
     *
     * @var string[]
     */
    protected $fillable = [
        'id',
        'name',
        'slug',
        'ev_data',
        'mpg_data',
        'autotrader_id',
    ];

    /**
     * Columns shown in JSON response by default
     *
     * @var string[]
     */
    protected $visible = [
        'id',
        'name',
        'slug',
        'ev_data',
        'mpg_data',
    ];

    protected static function boot()
    {
        parent::boot();

        self::saving(function (self $fuelType) {
            $fuelType->ensureSlug();
        });
    }

    /**
     * Model factory
     *
     * @return FuelTypeFactory
     */
    protected static function newFactory()
    {
        return FuelTypeFactory::new();
    }

    protected function getSlugAttribute(): string
    {
        return $this->attributes['slug'];
    }
}
