<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Mtc\Crm\Contracts\EnquiryModel;
use Mtc\MercuryDataModels\Contracts\SearchableModel;
use Mtc\MercuryDataModels\Tools\UiUrlGenerator;

class Enquiry extends EnquiryModel implements SearchableModel
{
    /**
     * Search name text
     *
     * @return string
     */
    public function getSearchNameAttribute(): string
    {
        return $this->title;
    }

    /**
     * Search excerpt text
     *
     * @return string
     */
    public function getSearchExcerptAttribute(): string
    {
        return strip_tags($this->message);
    }

    /**
     * Search result icon
     *
     * @return string
     */
    public function getSearchIcon(): string
    {
        return 'envelope';
    }

    /**
     * Route to viewing a vehicle as a part of search response
     *
     * @return string
     */
    public function getSearchResultRoute(): string
    {
        return UiUrlGenerator::make('crm/enquiries/view/' . $this->id, [], false);
    }

    /**
     * Related vehicle valuation
     *
     * @return BelongsTo
     */
    public function valuation(): BelongsTo
    {
        return $this->belongsTo(VehicleValuation::class);
    }

    public function getViewUrl(): string
    {
        return config('app.url') . "/crm/enquiries/view/{$this->id}";
    }
}
