<?php

namespace Mtc\MercuryDataModels\Filters;

use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleOffer;

class OfferMakeFilter extends MakeFilter
{
    /**
     * Get available results of this filter type
     *
     * @param \Closure $product_filtering
     * @param int $limit
     * @param array $selections
     * @return Collection
     */
    public function getResults(\Closure $product_filtering, int $limit, array $selections = []): Collection
    {
        $results = VehicleOffer::query()
            ->distinct()
            ->pluck('make_id');

        return VehicleMake::query()
            ->with('filterIndex')
            ->whereIn('id', $results)
            ->orderBy('name')
            ->distinct()
            ->get();
    }

}
