<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Mtc\MercuryDataModels\Factories\VehicleAttributeValueFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VehicleAttributeValue extends Model
{
    use HasFactory;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'vehicle_attribute_values';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'vehicle_id',
        'attribute_id',
        'slug',
        'type',
        'value',
        'value_float',
        'value_integer',
        'value_datetime',
        'value_text',
        'order',
        'index',
    ];

    /**
     * Model factory
     *
     * @return VehicleAttributeValueFactory
     */
    protected static function newFactory()
    {
        return VehicleAttributeValueFactory::new();
    }

    public function vehicle(): BelongsTo
    {
        return $this->belongsTo(Vehicle::class);
    }

    public function attribute(): BelongsTo
    {
        return $this->belongsTo(VehicleAttribute::class);
    }

    public function getValue()
    {
        return match($this->type) {
            'text' => $this->attributes['value_text'],
            'number' => $this->attributes['value_float'],
            'integer' => $this->attributes['value_integer'],
            'boolean' => (bool)$this->attributes['value_integer'],
            'datetime' => $this->attributes['value_datetime'],
            default => $this->attributes['value'],
        };
    }
}
