<?php

namespace Mtc\MercuryDataModels\Services;

use Exception;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Mtc\MercuryDataModels\Vehicle;

class FinanceService
{
    public function request(Vehicle $vehicle, array $data = []): bool
    {
        try {
            $result = Http::connectTimeout(1)
                ->withHeaders([
                    'x-tenant' => tenant('id'),
                    'accept' => 'application/json',
                    'content-type' => 'application/json',
                ])
                ->withOptions(["verify" => false])
                ->post($this->endpoint("request/$vehicle->slug"), $data);
            return $result->successful();
        } catch (Exception $exception) {
            Log::error($exception->getMessage());
        }
        return false;
    }

    public function requestAllVehicles(): bool
    {
        try {
            $result = Http::connectTimeout(1)
                ->withHeaders([
                    'x-tenant' => tenant('id'),
                    'accept' => 'application/json',
                    'content-type' => 'application/json',
                ])
                ->withOptions(["verify" => false])
                ->post($this->endpoint("request-all-vehicles"));
            return $result->successful();
        } catch (Exception $exception) {
            Log::error($exception->getMessage());
        }
        return false;
    }

    public function get(Vehicle $vehicle, array $data = []): array
    {
        try {
            $result = Http::connectTimeout(1)
                ->withHeaders([
                    'x-tenant' => tenant('id'),
                    'accept' => 'application/json',
                    'content-type' => 'application/json',
                ])
                ->withOptions(["verify" => false])
                ->post($this->endpoint("request-now/$vehicle->slug"), $data);

            if ($result->successful()) {
                return $result->json();
            }
            Log::warning('failed requesting finance', [
                'url' => $this->endpoint("request-now/$vehicle->slug"),
                'status' => $result->status(),
                'result' => $result->json(),
                'response' => $result->body(),
            ]);
        } catch (Exception $exception) {
            Log::error($exception->getMessage());
        }
        return $this->errorMessage();
    }

    public function triggerExport(): bool
    {
        try {
            $result = Http::connectTimeout(1)
                ->withHeaders([
                    'x-tenant' => tenant('id'),
                    'accept' => 'application/json',
                    'content-type' => 'application/json',
                ])
                ->withOptions(["verify" => false])
                ->post($this->endpoint("export"));
            return $result->successful();
        } catch (Exception $exception) {
            Log::error($exception->getMessage());
        }
        return false;
    }

    private function errorMessage(): array
    {
        return [
            'status' => 'fail',
            'message' => 'Could not request finance calculation for the request',
        ];
    }

    private function endpoint(string $string): string
    {
        return rtrim(config('features.finance-service.domain'), '/') . '/' . $string;
    }
}
