<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Relations\HasMany;
use Mtc\MercuryDataModels\Factories\VehicleAttributeFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Mtc\MercuryDataModels\Traits\EnsuresSlug;

class VehicleAttribute extends Model
{
    use HasFactory;
    use EnsuresSlug;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'vehicle_attributes';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'name',
        'type',
        'slug',
        'validation',
        'count',
        'data',
        'order',
        'sortable',
        'filterable',
    ];

    protected $casts = [
        'validation' => 'array',
        'data' => 'array',
    ];

    /**
     * Model factory
     *
     * @return VehicleAttributeFactory
     */
    protected static function newFactory()
    {
        return VehicleAttributeFactory::new();
    }

    protected static function boot()
    {
        parent::boot();
        self::creating(fn (self $model) => $model->ensureSlug());
    }

    public function values(): HasMany
    {
        return $this->hasMany(VehicleAttributeValue::class, 'attribute_id');
    }
}
