<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Mtc\MercuryDataModels\Factories\VehicleTechDataFactory;

class VehicleTechnicalData extends Model
{
    use HasFactory;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'vehicle_tech_data';

    /**
     * @var string[]
     */
    protected $fillable = [
        'vehicle_id',
        'vehicle_type',
        'code',
        'description',
        'value',
        'category'
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    protected static function newFactory()
    {
        return VehicleTechDataFactory::new();
    }

    public function vehicle(): BelongsTo
    {
        return $this->belongsTo(Vehicle::class, 'vehicle_id');
    }

    public function owner(): MorphTo
    {
        return $this->morphTo('vehicle');
    }
}
