<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

class AddCountriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('countries', function (Blueprint $table) {
            $table->id();
            $table->boolean('status')->default(1)->index();
            $table->integer('order')->default(0)->index();
            $table->string('code', 2)->default('')->index();
            $table->string('name', 45)->default('')->index();
            $table->string('currency_code', 3)->nullable()->index();
            $table->double('north')->nullable();
            $table->double('south')->nullable();
            $table->double('east')->nullable();
            $table->double('west')->nullable();
            $table->string('capital_name', 30)->nullable();
            $table->string('continent_name', 15)->nullable();
            $table->string('continent_code', 2)->nullable();
            $table->string('languages', 100)->nullable();
            $table->string('iso_code', 3)->nullable()->index();
            $table->string('dial_code', 10)->nullable();
            $table->boolean('is_eu')->default(0)->index();
            $table->boolean('has_postcodes')->default(1)->index();
            $table->string('postcode_regex')->nullable();
            $table->string('number_plate_regex')->nullable();
            $table->timestamps();
            $table->unique('code');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('countries');
    }
}
