<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DealershipDepartment extends Model
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'dealership_departments';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'dealership_id',
        'name',
        'contact_no',
        'email',
        'open_times',
        'is_primary',
    ];

    /**
     * Cast attributes to types
     *
     * @var string[]
     */
    protected $casts = [
        'open_times' => 'array',
        'is_primary' => 'boolean',
    ];

    public function dealership(): BelongsTo
    {
        return $this->belongsTo(Dealership::class, 'dealership_id');
    }
}
