<?php

namespace Mtc\MercuryDataModels\Filters;

use App\Facades\Settings;
use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\TransmissionType;
use Mtc\MercuryDataModels\VehicleOffer;

class OfferTransmissionFilter extends TransmissionFilter
{
    /**
     * Get available results of this filter type
     *
     * @param \Closure $product_filtering
     * @param int $limit
     * @param array $selections
     * @return Collection
     */
    public function getResults(\Closure $product_filtering, int $limit, array $selections = []): Collection
    {
        $results = VehicleOffer::query()
            ->distinct()
            ->when(Settings::get('filter-apply-selections-to-results'), fn($query) => $query->where($product_filtering))
            ->pluck('transmission_id');

        return TransmissionType::query()
            ->distinct()
            ->whereIn('id', $results)
            ->distinct()
            ->get();
    }
}
