<?php

namespace Mtc\MercuryDataModels;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Mtc\MercuryDataModels\Factories\LabelRuleFactory;

class LabelRule extends Model
{
    use HasFactory;

    protected $table = 'label_rules';

    protected $fillable = [
        'label_id',
        'condition_field',
        'condition_value',
        'value_data_type',
    ];

    protected $appends = [
        'friendly_name'
    ];

    public function getValue()
    {
        $vrm_with_non_json_value = in_array($this->condition_field, ['vrms_included', 'vrms_excluded'])
            && !is_array(json_decode($this->condition_value));

        if ($vrm_with_non_json_value) {
            return explode("\n", $this->condition_value);
        }

        return match ($this->value_data_type) {
            'integer' => (int)$this->condition_value,
            'float' => (float)$this->condition_value,
            'decimal' => (float)$this->condition_value,
            'boolean' => (bool)$this->condition_value,
            'json' => json_decode($this->condition_value, true),
            'date', 'datetime' => Carbon::parse($this->condition_value),
            default => $this->condition_value
        };
    }

    protected function getFriendlyNameAttribute()
    {
        $name = $this->condition_field;
        $name = str_replace('_ids', '', $name);
        $name = str_replace('_id', '', $name);
        $name = str_replace('_', ' ', $name);

        return ucwords($name);
    }

    protected static function newFactory()
    {
        return LabelRuleFactory::new();
    }
}
