<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Mtc\Filter\FilterIndex;
use Mtc\MercuryDataModels\Factories\ColourFactory;

class Colour extends Model
{
    use HasFactory;

    protected $table = 'colours';

    protected $fillable = [
        'colour',
        'hex_code',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    protected static function newFactory()
    {
        return ColourFactory::new();
    }

    public function mappedColours(): HasMany
    {
        return $this->hasMany(ColourMap::class, 'colour_id');
    }

    public function filterIndex(): MorphOne
    {
        return $this->morphOne(FilterIndex::class, 'filter');
    }

    protected function getSlugAttribute(): string
    {
        return $this->filterIndex?->slug ?? '';
    }
}
