<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Relations\HasMany;
use Mtc\MercuryDataModels\Features\ServiceBooking;
use Mtc\VehicleReservations\Reservation;

use OwenIt\Auditing\Auditable;
use function config;

class Customer extends \Mtc\Crm\Contracts\Customer implements \OwenIt\Auditing\Contracts\Auditable
{
    use Auditable;

    public function reservations(): HasMany
    {
        return $this->hasMany(Reservation::class, 'customer_id');
    }

    public function serviceBookings(): HasMany
    {
        return $this->hasMany(ServiceBooking::class, 'customer_id');
    }
}
