<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Relations\HasMany;
use Mtc\MercuryDataModels\Contracts\ModelWithContent;
use OwenIt\Auditing\Contracts\Auditable;

class Template extends \Mtc\ContentManager\Contracts\Template implements Auditable, ModelWithContent
{
    use \OwenIt\Auditing\Auditable;

    public function offers(): HasMany
    {
        return  $this->hasMany(VehicleOffer::class, 'template_id');
    }

    public function newVehicles(): HasMany
    {
        return $this->hasMany(NewCar::class, 'template_id');
    }

    public function content(): HasMany
    {
        return new HasMany();
    }

    public function allContent(): HasMany
    {
        return new HasMany();
    }
}
