<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Str;
use Mtc\MercuryDataModels\Factories\VehicleAttributeFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Mtc\MercuryDataModels\Traits\EnsuresSlug;

class VehicleAttribute extends Model
{
    use HasFactory;
    use EnsuresSlug;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'vehicle_attributes';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'name',
        'type',
        'slug',
        'validation',
        'count',
        'data',
        'order',
        'sortable',
        'filterable',
        'model'
    ];

    protected $casts = [
        'validation' => 'array',
        'data' => 'array',
    ];

    /**
     * Model factory
     *
     * @return VehicleAttributeFactory
     */
    protected static function newFactory()
    {
        return VehicleAttributeFactory::new();
    }

    protected static function boot()
    {
        parent::boot();
        self::creating(fn (self $model) => $model->ensureSlug());
    }

    public function values(): HasMany
    {
        return $this->hasMany(VehicleAttributeValue::class, 'attribute_id');
    }

    private function ensureSlug()
    {
        if (empty($this->attributes['slug'])) {
            $slug = Str::slug($this->attributes['name']);
            $this->attributes['slug'] = $slug;

            $loop = 1;
            while (self::query()->where('slug', $this->slug)->where('model', $this->model)->exists()) {
                $this->attributes['slug'] = $slug . '-' . ($loop++);
            }
        }
    }
}
