<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInvoiceTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->id();
            $table->string('tenant_id')->index();
            $table->string('email')->index();
            $table->string('status', 20)->index();
            $table->date('due_at');
            $table->dateTime('paid_at')->nullable()->index();
            $table->decimal('amount');
            $table->decimal('amount_paid')->default(0);
            $table->smallInteger('vat_rate')->nullable();
            $table->text('data')->nullable();
            $table->string('pdf_path')->nullable();
            $table->timestamps();
        });

        Schema::create('invoice_addresses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('invoice_id')->nullable()->index();
            $table->string('type', 20)->index();
            $table->string('title')->nullable();
            $table->string('first_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('address1')->nullable();
            $table->string('address2')->nullable();
            $table->string('city')->nullable();
            $table->string('county')->nullable();
            $table->string('postcode')->nullable();
            $table->string('state')->nullable();
            $table->string('country')->nullable();
            $table->timestamps();
        });

        Schema::create('invoice_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('invoice_id')->nullable()->index();
            $table->foreignId('billable_id')->nullable()->index();
            $table->string('name')->nullable();
            $table->decimal('price');
            $table->decimal('discounted_price')->nullable();
            $table->integer('quantity')->default(1);
            $table->decimal('line_total');
            $table->text('details')->nullable();
            $table->timestamps();
        });

        Schema::create('invoice_payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('invoice_id')->nullable()->index();
            $table->string('provider', 100)->index();
            $table->decimal('amount', 10);
            $table->string('reference', 100)->index();
            $table->dateTime('confirmed_at')->nullable()->index();
            $table->text('details')->nullable();
            $table->timestamps();
        });

        Schema::create('invoice_history', function (Blueprint $table) {
            $table->id();
            $table->foreignId('invoice_id')->index();
            $table->string('type')->index();
            $table->string('title');
            $table->text('details')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoices');
        Schema::dropIfExists('invoice_addresses');
        Schema::dropIfExists('invoice_items');
        Schema::dropIfExists('invoice_payments');
        Schema::dropIfExists('invoice_history');
    }
}
