<?php

namespace Mtc\MercuryDataModels;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class BookingAvailability extends Model
{
    use HasFactory;

    protected $table = 'service_location_availability';

    protected $fillable = [
        'dealership_id',
        'active',
        'number_of_bays',
        'time_windows',
        'mondays',
        'tuesdays',
        'wednesdays',
        'thursdays',
        'fridays',
        'saturdays',
        'sundays',
    ];

    protected $casts = [
        'active' => 'boolean',
        'time_windows' => 'array',
        'mondays' => 'boolean',
        'tuesdays' => 'boolean',
        'wednesdays' => 'boolean',
        'thursdays' => 'boolean',
        'fridays' => 'boolean',
        'saturdays' => 'boolean',
        'sundays' => 'boolean',

    ];

    public function dealership(): BelongsTo
    {
        return $this->belongsTo(Dealership::class, 'dealership_id');
    }

    public function holidays(): HasMany
    {
        return $this->hasMany(BookingAvailabilityHoliday::class, 'availability_id');
    }

    public function upcomingHolidays(): HasMany
    {
        return $this->hasMany(BookingAvailabilityHoliday::class, 'availability_id')
            ->where('holiday_date', '>=', Carbon::now());
    }

    public function allocateHolidays(array $holidays): void
    {
        collect($holidays)
            ->each(fn ($holiday) => $this->upcomingHolidays()->updateOrCreate(['holiday_date' => $holiday]));
    }

}
