<?php

namespace Mtc\MercuryDataModels;

use Mtc\ContentManager\Contracts\ContentElement as ContentElementModel;

class ContentElement extends ContentElementModel
{
    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'title',
        'slug',
        'subtitle',
        'icon',
        'category',
        'is_enabled',
        'ui_component',
        'drag_and_drop',
        'data',
    ];

    /**
     * Name of the element category
     *
     * @return string
     */
    public function categoryName(): string
    {
        return collect(config('pages.block_categories', []))
            ->filter(fn (array $category) => $category['id'] === $this->category)
            ->first()['name'] ?? '';
    }
}
