<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use Mtc\MercuryDataModels\SeoRedirect;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\Mtc\MercuryDataModels\SeoDefault>
 */
class SeoRedirectFactory extends Factory
{
    protected $model = SeoRedirect::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        return [
            'from' => '/' . $this->faker->word() . Str::random(5),
            'to' => '/' . $this->faker->word() . Str::random(5),
            'code' => random_int(300, 310),
        ];
    }
}
