<?php

namespace Mtc\MercuryDataModels;

use Mtc\MercuryDataModels\Factories\ClientInvoicePaymentFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class ClientInvoicePayment extends Model
{
    use HasFactory;
    use CentralConnection;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'invoice_payments';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'invoice_id',
        'provider',
        'amount',
        'reference',
        'confirmed_at',
        'details',
    ];

    /**
     * Cast attributes to types
     *
     * @var string[]
     */
    protected $casts = [
        'confirmed_at' => 'datetime',
        'details' => 'array',
    ];

    /**
     * Model Factory
     *
     * @return ClientInvoicePaymentFactory
     */
    protected static function newFactory()
    {
        return ClientInvoicePaymentFactory::new();
    }

    /**
     * Relationship with invoice
     *
     * @return BelongsTo
     */
    public function invoice(): BelongsTo
    {
        return $this->belongsTo(ClientInvoice::class);
    }
}
