<?php

namespace Mtc\MercuryDataModels;

use Mtc\MercuryDataModels\Factories\ClientInvoiceAddressFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Mtc\MercuryDataModels\Factories\CustomerInvoiceAddressFactory;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class CustomerInvoiceAddress extends Model
{
    use HasFactory;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'invoice_addresses';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'invoice_id',
        'type',
        'title',
        'company_name',
        'first_name',
        'last_name',
        'address1',
        'address2',
        'city',
        'county',
        'postcode',
        'country',
        'state',
    ];

    /**
     * Model Factory
     *
     * @return CustomerInvoiceAddressFactory
     */
    protected static function newFactory()
    {
        return CustomerInvoiceAddressFactory::new();
    }

    /**
     * Relationship with invoice
     *
     * @return BelongsTo
     */
    public function invoice(): BelongsTo
    {
        return $this->belongsTo(CustomerInvoiceAddress::class);
    }
}
