<?php

namespace Mtc\MercuryDataModels;

use Mtc\MercuryDataModels\Factories\ClientInvoiceHistoryFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Mtc\MercuryDataModels\Factories\CustomerInvoiceHistoryFactory;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class CustomerInvoiceHistory extends Model
{
    use HasFactory;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'invoice_history';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'invoice_id',
        'type',
        'title',
        'details',
    ];

    /**
     * Cast attributes to types
     *
     * @var string[]
     */
    protected $casts = [
        'details' => 'array',
    ];

    /**
     * Model Factory
     *
     * @return CustomerInvoiceHistoryFactory
     */
    protected static function newFactory()
    {
        return CustomerInvoiceHistoryFactory::new();
    }

    /**
     * Relationship with invoice
     *
     * @return BelongsTo
     */
    public function invoice(): BelongsTo
    {
        return $this->belongsTo(CustomerInvoice::class);
    }
}
