<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Mtc\MercuryDataModels\Factories\CustomerInvoiceItemFactory;

class CustomerInvoiceItem extends Model
{
    use HasFactory;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'invoice_items';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'purchasable_id',
        'purchasable_type',
        'invoice_id',
        'name',
        'price',
        'price_ex_vat',
        'original_price',
        'original_price_ex_vat',
        'details',
    ];

    /**
     * Cast attributes to types
     *
     * @var string[]
     */
    protected $casts = [
        'details' => 'array',
    ];

    /**
     * Model Factory
     *
     * @return CustomerInvoiceItemFactory
     */
    protected static function newFactory()
    {
        return CustomerInvoiceItemFactory::new();
    }

    /**
     * Relationship with invoice
     *
     * @return BelongsTo
     */
    public function invoice(): BelongsTo
    {
        return $this->belongsTo(ClientInvoice::class);
    }

    public function purchasable(): MorphTo
    {
        return $this->morphTo('purchasable');
    }
}
