<?php

namespace Mtc\MercuryDataModels;

use Mtc\MercuryDataModels\Factories\ClientInvoicePaymentFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Mtc\MercuryDataModels\Factories\CustomerInvoicePaymentFactory;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class CustomerInvoicePayment extends Model
{
    use HasFactory;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'invoice_payments';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'invoice_id',
        'provider',
        'amount',
        'reference',
        'confirmed_at',
        'details',
    ];

    /**
     * Cast attributes to types
     *
     * @var string[]
     */
    protected $casts = [
        'confirmed_at' => 'datetime',
        'details' => 'array',
    ];

    /**
     * Model Factory
     *
     * @return CustomerInvoicePaymentFactory
     */
    protected static function newFactory()
    {
        return CustomerInvoicePaymentFactory::new();
    }

    /**
     * Relationship with invoice
     *
     * @return BelongsTo
     */
    public function invoice(): BelongsTo
    {
        return $this->belongsTo(CustomerInvoice::class);
    }
}
