<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\ClientInvoiceItem;

class ClientInvoiceItemFactory extends Factory
{
    protected $model = ClientInvoiceItem::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'invoice_id' => random_int(0, 50),
            'name' => $this->faker->sentence(),
            'price' => random_int(50, 1000),
            'discounted_price' => random_int(0, 3) ? 0 : random_int(30, 1000),
            'quantity' => random_int(1, 6),
            'line_total' => random_int(100, 3000),
            'details' => [],
        ];
    }
}
