<?php

namespace Mtc\MercuryDataModels\Factories;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use Mtc\MercuryDataModels\ClientInvoicePayment;

class ClientInvoicePaymentFactory extends Factory
{
    protected $model = ClientInvoicePayment::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'invoice_id' => random_int(0, 50),
            'provider' => random_int(0, 3) ? 'stripe' : 'manual',
            'amount' => random_int(500, 50000),
            'reference' => Str::random(30),
            'confirmed_at' => Carbon::now()->addDays(random_int(-50, 10)),
            'details' => [],
        ];
    }
}
