<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\ClientInvoiceAddress;
use Mtc\MercuryDataModels\CustomerInvoiceAddress;

class CustomerInvoiceAddressFactory extends Factory
{
    protected $model = CustomerInvoiceAddress::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'invoice_id' => random_int(0, 50),
            'type' => random_int(0, 1) ? 'seller' : 'recipient',
            'title' => $this->faker->title(),
            'first_name' => $this->faker->firstName(),
            'last_name' => $this->faker->lastName(),
            'address1' => $this->faker->address(),
            'address2' => random_int(0, 1) ? $this->faker->streetAddress() : '',
            'city' => $this->faker->city(),
            'county' => '',
            'postcode' => $this->faker->postcode(),
            'country' => $this->faker->countryCode(),
            'state' => '',
        ];
    }
}
