<?php

namespace Mtc\MercuryDataModels\Factories;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\ClientInvoice;
use Mtc\MercuryDataModels\CustomerInvoice;
use Mtc\MercuryDataModels\InvoiceStatus;
use Mtc\MercuryDataModels\PurchaseAddOn;

class PurchaseAddOnFactory extends Factory
{
    protected $model = PurchaseAddOn::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $amount = random_int(50, 15000);
        return [
            'name' => $this->faker->word(),
            'description' => $this->faker->sentence(),
            'price' => $amount,
            'price_ex_vat' => random_int(0, 1) ? $amount : 0,
            'active' => random_int(0, 1),
            'data' => [],
        ];
    }
}
