<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\ClientInvoice;
use Mtc\MercuryDataModels\TenantBillingDetail;

class TenantBillingDetailFactory extends Factory
{
    protected $model = TenantBillingDetail::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'tenant_id' => random_int(0, 50),
            'vat_rate' => random_int(0, 3) ? ClientInvoice::REGULAR_VAT : ClientInvoice::NO_VAT,
            'billing_email' => $this->faker->safeEmail(),
            'contact_no' => $this->faker->phoneNumber(),
            'title' => $this->faker->title(),
            'first_name' => $this->faker->firstName(),
            'last_name' => $this->faker->lastName(),
            'address1' => $this->faker->address(),
            'address2' => random_int(0, 1) ? $this->faker->streetAddress() : '',
            'city' => $this->faker->city(),
            'county' => '',
            'postcode' => $this->faker->postcode(),
            'country' => $this->faker->countryCode(),
            'state' => '',
        ];
    }
}
