<?php

namespace Mtc\MercuryDataModels\Filters;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;

abstract class IsFilter extends \Mtc\Filter\Contracts\IsFilter
{
    // by default, filter options are hidden if only one option is available
    protected int $min_count_to_show = 2;

    /**
     * Format result for front-end
     *
     * @param Collection $collection
     * @return array
     */
    public function format(Collection $collection): array
    {
        return [
            'title' => $this->title(),
            'ui_component' => $this->uiComponentType(),
            'has_load_more' => $this->hasLoadMore($collection),
            'show' => $this->visibleByDefault(),
            'min_count_to_show' => $this->minCountToShow(),
            'results' => $collection->map(fn(Model $model) => [
                'id' => $model[$this->getIdAttribute()],
                'name' => $model[$this->getNameAttribute()],
                'count' => $model->result_count,
            ]),
        ];
    }

    protected function minCountToShow()
    {
        return $this->min_count_to_show;
    }

    protected function visibleByDefault(): bool
    {
        return false;
    }

}
