<?php

namespace Mtc\MercuryDataModels;

use Mtc\Crm\Traits\ModelSortAndFilter;
use Mtc\MercuryDataModels\Factories\FuelTypeFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Mtc\MercuryDataModels\Traits\OrderByName;

class FuelType extends Model
{
    use HasFactory;
    use OrderByName;
    use ModelSortAndFilter;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'fuel_types';

    /**
     * Mass assign columns
     *
     * @var string[]
     */
    protected $fillable = [
        'id',
        'name',
        'ev_data',
        'mpg_data',
        'autotrader_id',
    ];

    /**
     * Columns shown in JSON response by default
     *
     * @var string[]
     */
    protected $visible = [
        'id',
        'name',
        'ev_data',
        'mpg_data',
    ];

    /**
     * Model factory
     *
     * @return FuelTypeFactory
     */
    protected static function newFactory()
    {
        return FuelTypeFactory::new();
    }
}
