<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Mtc\MercuryDataModels\Factories\LabelFactory;

class Label extends Model
{
    use HasFactory;

    protected $table = 'labels';

    protected $fillable = [
        'name',
        'type',
        'data',
    ];

    protected $casts = [
        'data' => 'array',
    ];

    protected static function newFactory()
    {
        return LabelFactory::new();
    }

    public function vehicles(): BelongsToMany
    {
        return $this->belongsToMany(Vehicle::class, 'vehicle_labels');
    }

    public function offers(): BelongsToMany
    {
        return $this->belongsToMany(VehicleOffer::class, 'vehicle_offer_labels');
    }
}
