<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Relations\MorphMany;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Mtc\MercuryDataModels\Factories\PurchaseAddOnFactory;

class PurchaseAddOn extends Model
{
    use HasFactory;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'purchase_add_ons';

    /**
     * Mass assign attributes
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'description',
        'active',
        'price',
        'price_ex_vat',
    ];


    /**
     * Model Factory
     *
     * @return PurchaseAddOnFactory
     */
    protected static function newFactory()
    {
        return PurchaseAddOnFactory::new();
    }

    /**
     * Relationship with invoice items
     *
     * @return MorphMany
     */
    public function invoiceItems(): MorphMany
    {
        return $this->morphMany(CustomerInvoiceItem::class, 'purchasable');
    }

    public function scopeActive(Builder $query)
    {
        return $query->where('active', 1);
    }

    public function scopeApplicableTo(Builder $query, Vehicle $vehicle)
    {
        return $query;
    }
}
