<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Mtc\MercuryDataModels\Factories\SeoDataFactory;

class SeoData extends Model
{
    use HasFactory;

    public const TITLE_MIN_LENGTH = 43;
    public const DESCRIPTION_MIN_LENGTH = 100;

    protected $table = 'seo_data';

    /**
     * Mass assign
     *
     * @var string[]
     */
    protected $fillable = [
        'path',
        'title',
        'description',
        'heading',
    ];

    /**
     * Hide from JSON
     *
     * @var string[]
     */
    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    /**
     * New model factory
     *
     * @return SeoDataFactory
     */
    protected static function newFactory()
    {
        return SeoDataFactory::new();
    }
}
