<?php

namespace Mtc\MercuryDataModels\Traits;

use Illuminate\Support\Collection;
use Illuminate\Support\Str;
use Mtc\ContentManager\Facades\Fields;
use Mtc\MercuryDataModels\Events\LoadVehicleDataFields;
use Mtc\MercuryDataModels\VehicleAttribute;
use Mtc\MercuryDataModels\VehicleAttributeValue;

trait HasVehicleCustomAttributes
{
    private function getExtraData()
    {
        return collect(event(new LoadVehicleDataFields($this->resource)))
            ->filter()
            ->mapWithKeys(fn($field) => $field)
            ->map(function ($field, $key) {
                $field['id'] = $key;
                return $field;
            })->values()
            ->merge($this->getCustomAttributes());
    }

    private function getCustomAttributes(): Collection
    {
        $this->resource->load('attributeValues');
        return VehicleAttribute::all()
            ->map(fn(VehicleAttribute $attribute) => $this->allocateAttributeValues($attribute));
    }

    private function allocateAttributeValues(VehicleAttribute $attribute): array
    {
        /** @var Collection $values */
        $values = $this->resource->attributeValues
            ->where('attribute_id', $attribute->id)
            ->map(fn(VehicleAttributeValue $value) => [
                'id' => $value->id,
                'value' => $value->getValue(),
            ])->take($attribute->count)
            ->toArray();
        $values = collect($values);
        if ($values->count() < $attribute->count) {
            $values = $values->merge(array_fill(0, $attribute->count - $values->count(), [
                'id' => Str::random(),
                'value' => null,
            ]));
        }
        return [
            'id' => $attribute->id,
            'name' => $attribute->name,
            'slug' => $attribute->slug,
            'type' => $attribute->type,
            'component' => 'EditableContent' . Fields::field($attribute->type)->getComponent(),
            'value' => $values,
            'meta' => $attribute->data,
        ];
    }
}
