<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('content_categories', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('slug')->index();
            $table->unsignedInteger('external_id')->index();
            $table->timestamps();
        });
        Schema::create('page_categories', function (Blueprint $table) {
            $table->id();
            $table->foreignId('page_id');
            $table->foreignId('category_id');
            $table->index(['page_id', 'category_id']);
            $table->timestamps();
        });
        Schema::create('content_tags', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('slug')->index();
            $table->unsignedInteger('external_id')->index();
            $table->timestamps();
        });
        Schema::create('page_tags', function (Blueprint $table) {
            $table->id();
            $table->foreignId('page_id');
            $table->foreignId('tag_id');
            $table->index(['page_id', 'tag_id']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('content_categories');
        Schema::dropIfExists('page_categories');
        Schema::dropIfExists('content_tags');
        Schema::dropIfExists('page_tags');
    }
};
